package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutBucketNotification

Enables Amazon SNS notifications of specified events for a bucket.
*/
public class PutBucketNotification extends Choreography {

	/**
	Create a new instance of the PutBucketNotification Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutBucketNotification(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/PutBucketNotification"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutBucketNotificationInputSet
	*/
	public PutBucketNotificationInputSet newInputSet() {
		return new PutBucketNotificationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutBucketNotificationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutBucketNotificationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutBucketNotification
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutBucketNotificationInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket to create a notification for.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the Event input for this Choreo. 

		@param String - (optional, string) A bucket event for which to send notifications. Valid value:  "s3:ReducedRedundancyLostObject" (The default and currently only supported notification event).
		*/
		public void set_Event(String value) {
			this.setInput("Event", value);
		}


		/** 
		Set the value of the Topic input for this Choreo. 

		@param String - (conditional, string) The Amazon SNS topic arn that  Amazon S3 will publish a message to report the specified events for the bucket. If this is not supplied, notifications will be turned off.
		*/
		public void set_Topic(String value) {
			this.setInput("Topic", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutBucketNotification Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutBucketNotificationResultSet extends ResultSet {
		public PutBucketNotificationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) Stores the response from Amazon. Note that for a successful execution, no content is returned and this output variable should be empty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
