package com.temboo.Library.Amazon.EC2;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ImportKeyPair

Calls the Amazon EC2 API to import the public key from an RSA key pair that you created with a third-party tool.
*/
public class ImportKeyPair extends Choreography {

	/**
	Create a new instance of the ImportKeyPair Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ImportKeyPair(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/EC2/ImportKeyPair"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ImportKeyPairInputSet
	*/
	public ImportKeyPairInputSet newInputSet() {
		return new ImportKeyPairInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ImportKeyPairResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ImportKeyPairResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ImportKeyPair
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ImportKeyPairInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the KeyName input for this Choreo. 

		@param String - (required, string) A unique name for the key pair.
		*/
		public void set_KeyName(String value) {
			this.setInput("KeyName", value);
		}


		/** 
		Set the value of the PublicKeyMaterial input for this Choreo. 

		@param String - (required, string) The public key. You must Base64-encode the public key material before sending it to AWS.
		*/
		public void set_PublicKeyMaterial(String value) {
			this.setInput("PublicKeyMaterial", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ImportKeyPair Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ImportKeyPairResultSet extends ResultSet {
		public ImportKeyPairResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
