package com.temboo.Library.Amazon.EC2;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AuthorizeSecurityGroupIngress

Adds an ingress rule to a security group using the Amazon EC2 API.
*/
public class AuthorizeSecurityGroupIngress extends Choreography {

	/**
	Create a new instance of the AuthorizeSecurityGroupIngress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AuthorizeSecurityGroupIngress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/EC2/AuthorizeSecurityGroupIngress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AuthorizeSecurityGroupIngressInputSet
	*/
	public AuthorizeSecurityGroupIngressInputSet newInputSet() {
		return new AuthorizeSecurityGroupIngressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AuthorizeSecurityGroupIngressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AuthorizeSecurityGroupIngressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AuthorizeSecurityGroupIngress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AuthorizeSecurityGroupIngressInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the GroupId input for this Choreo. 

		@param String - (conditional, string) The ID of the security group to modify. Can be used instead of GroupName.
		*/
		public void set_GroupId(String value) {
			this.setInput("GroupId", value);
		}


		/** 
		Set the value of the GroupName input for this Choreo. 

		@param String - (conditional, string) The name of the security group to modify. Can be used instead of GroupId.
		*/
		public void set_GroupName(String value) {
			this.setInput("GroupName", value);
		}


		/** 
		Set the value of the IpPermissionsCidrIp input for this Choreo. 

		@param String - (optional, string) The CIDR range. Cannot be used when specifying a source security group.
		*/
		public void set_IpPermissionsCidrIp(String value) {
			this.setInput("IpPermissionsCidrIp", value);
		}


		/** 
		Set the value of the IpPermissionsFromPort input for this Choreo. 

		@param Integer - (optional, integer) The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, you can use -1 to specify all ICMP types.
		*/
		public void set_IpPermissionsFromPort(Integer value) {
			this.setInput("IpPermissionsFromPort", value);
		}

		/** 
		Set the value of the IpPermissionsFromPort input for this Choreo as a String. 

		@param String - (optional, integer) The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, you can use -1 to specify all ICMP types.
		*/
		public void set_IpPermissionsFromPort(String value) {
			this.setInput("IpPermissionsFromPort", value);	
		}
		/** 
		Set the value of the IpPermissionsGroupId input for this Choreo. 

		@param String - (optional, string) The ID of the source security group. Cannot be used when specifying a CIDR IP address.
		*/
		public void set_IpPermissionsGroupId(String value) {
			this.setInput("IpPermissionsGroupId", value);
		}


		/** 
		Set the value of the IpPermissionsGroupName input for this Choreo. 

		@param String - (optional, string) The name of the source security group. Cannot be used when specifying a CIDR IP address.
		*/
		public void set_IpPermissionsGroupName(String value) {
			this.setInput("IpPermissionsGroupName", value);
		}


		/** 
		Set the value of the IpPermissionsIpProtocol input for this Choreo. 

		@param String - (required, string) The IP protocol name or number. Valid values for EC2-Classic: tcp, udp, icmp (or 6, 17, 1). Valid values for EC2-VPC: tcp, udp, icmp, any valid protocol number (0-254), or -1 (to specify all).
		*/
		public void set_IpPermissionsIpProtocol(String value) {
			this.setInput("IpPermissionsIpProtocol", value);
		}


		/** 
		Set the value of the IpPermissionsToPort input for this Choreo. 

		@param Integer - (optional, integer) The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, you can use -1 to specify all ICMP codes for the given ICMP type.
		*/
		public void set_IpPermissionsToPort(Integer value) {
			this.setInput("IpPermissionsToPort", value);
		}

		/** 
		Set the value of the IpPermissionsToPort input for this Choreo as a String. 

		@param String - (optional, integer) The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, you can use -1 to specify all ICMP codes for the given ICMP type.
		*/
		public void set_IpPermissionsToPort(String value) {
			this.setInput("IpPermissionsToPort", value);	
		}
		/** 
		Set the value of the IpPermissionsUserId input for this Choreo. 

		@param String - (optional, string) The AWS account ID that owns the source security group. Cannot be used when specifying a CIDR IP address.
		*/
		public void set_IpPermissionsUserId(String value) {
			this.setInput("IpPermissionsUserId", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AuthorizeSecurityGroupIngress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AuthorizeSecurityGroupIngressResultSet extends ResultSet {
		public AuthorizeSecurityGroupIngressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
