package com.temboo.Library.PagerDuty.Incidents;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListIncidents

Allows you to list or search PagerDuty incidents.
*/
public class ListIncidents extends Choreography {

	/**
	Create a new instance of the ListIncidents Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListIncidents(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PagerDuty/Incidents/ListIncidents"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListIncidentsInputSet
	*/
	public ListIncidentsInputSet newInputSet() {
		return new ListIncidentsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListIncidentsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListIncidentsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListIncidents
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListIncidentsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by PagerDuty.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AssignedToUser input for this Choreo. 

		@param String - (optional, string) Returns only incidents assigned to the specified user.
		*/
		public void set_AssignedToUser(String value) {
			this.setInput("AssignedToUser", value);
		}


		/** 
		Set the value of the DateRange input for this Choreo. 

		@param String - (optional, string) When set to "all", this allows you to retrieve all incidents since the account was created.
		*/
		public void set_DateRange(String value) {
			this.setInput("DateRange", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Allows you to select specific incident properties to be returned in the response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the IncidentKey input for this Choreo. 

		@param String - (optional, string) Returns only incidents with the specified key.
		*/
		public void set_IncidentKey(String value) {
			this.setInput("IncidentKey", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of incidents returned. Default (and max limit) is 100.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of incidents returned. Default (and max limit) is 100.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) The offset of the first incident record returned. Default is 0.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) The offset of the first incident record returned. Default is 0.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Service input for this Choreo. 

		@param String - (optional, string) Returns only incidents associated with the specified service.
		*/
		public void set_Service(String value) {
			this.setInput("Service", value);
		}


		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) Used to specify both the field you wish to sort the results on (incident_number, created_on, or resolved_on), as well as the direction (asc/desc) of the results (e.g., created_on:desc).
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the Status input for this Choreo. 

		@param String - (optional, string) Returns only the incidents with this specified status. Valid values are: triggered, acknowledged, and resolved.
		*/
		public void set_Status(String value) {
			this.setInput("Status", value);
		}


		/** 
		Set the value of the SubDomain input for this Choreo. 

		@param String - (required, string) The subdomain of your PagerDuty site address.
		*/
		public void set_SubDomain(String value) {
			this.setInput("SubDomain", value);
		}


		/** 
		Set the value of the TimeZone input for this Choreo. 

		@param String - (optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
		*/
		public void set_TimeZone(String value) {
			this.setInput("TimeZone", value);
		}


		/** 
		Set the value of the Until input for this Choreo. 

		@param String - (optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
		*/
		public void set_Until(String value) {
			this.setInput("Until", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListIncidents Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListIncidentsResultSet extends ResultSet {
		public ListIncidentsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PagerDuty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
