package com.temboo.Library.Fitbit.Devices;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateAlarm

Updates an existing alarm entry for a given device.
*/
public class UpdateAlarm extends Choreography {

	/**
	Create a new instance of the UpdateAlarm Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateAlarm(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Fitbit/Devices/UpdateAlarm"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateAlarmInputSet
	*/
	public UpdateAlarmInputSet newInputSet() {
		return new UpdateAlarmInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateAlarmResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateAlarmResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateAlarm
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateAlarmInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AlarmID input for this Choreo. 

		@param String - (required, string) The ID of the alarm to update.
		*/
		public void set_AlarmID(String value) {
			this.setInput("AlarmID", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Fitbit.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Fitbit.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the DeviceID input for this Choreo. 

		@param String - (required, string) The id of the device you would like to manage the alarm on.
		*/
		public void set_DeviceID(String value) {
			this.setInput("DeviceID", value);
		}


		/** 
		Set the value of the Enabled input for this Choreo. 

		@param Boolean - (required, boolean) Indicates whether or not the alarm is enabled. Valid values are: true and false.
		*/
		public void set_Enabled(Boolean value) {
			this.setInput("Enabled", value);
		}

		/** 
		Set the value of the Enabled input for this Choreo as a String. 

		@param String - (required, boolean) Indicates whether or not the alarm is enabled. Valid values are: true and false.
		*/
		public void set_Enabled(String value) {
			this.setInput("Enabled", value);	
		}
		/** 
		Set the value of the Label input for this Choreo. 

		@param String - (optional, string) A label for the alarm.
		*/
		public void set_Label(String value) {
			this.setInput("Label", value);
		}


		/** 
		Set the value of the Recurring input for this Choreo. 

		@param Boolean - (required, boolean) Specifies if this is a one-time or recurring alarm. Valid values are: true or false. When adding a recurring alarm, the WeekDays input is required.
		*/
		public void set_Recurring(Boolean value) {
			this.setInput("Recurring", value);
		}

		/** 
		Set the value of the Recurring input for this Choreo as a String. 

		@param String - (required, boolean) Specifies if this is a one-time or recurring alarm. Valid values are: true or false. When adding a recurring alarm, the WeekDays input is required.
		*/
		public void set_Recurring(String value) {
			this.setInput("Recurring", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that you want the response to be in: xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SnoozeCount input for this Choreo. 

		@param Integer - (required, integer) The maximum snooze count.
		*/
		public void set_SnoozeCount(Integer value) {
			this.setInput("SnoozeCount", value);
		}

		/** 
		Set the value of the SnoozeCount input for this Choreo as a String. 

		@param String - (required, integer) The maximum snooze count.
		*/
		public void set_SnoozeCount(String value) {
			this.setInput("SnoozeCount", value);	
		}
		/** 
		Set the value of the SnoozeLength input for this Choreo. 

		@param Integer - (required, integer) The number of minutes in between alarms when using the snooze option.
		*/
		public void set_SnoozeLength(Integer value) {
			this.setInput("SnoozeLength", value);
		}

		/** 
		Set the value of the SnoozeLength input for this Choreo as a String. 

		@param String - (required, integer) The number of minutes in between alarms when using the snooze option.
		*/
		public void set_SnoozeLength(String value) {
			this.setInput("SnoozeLength", value);	
		}
		/** 
		Set the value of the Time input for this Choreo. 

		@param String - (required, string) The time of the alarm in the format XX:XX+XX:XX (the hour, minute, and time offset from UTC). This will be converted to the timezone of the user's profile.
		*/
		public void set_Time(String value) {
			this.setInput("Time", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


		/** 
		Set the value of the Vibe input for this Choreo. 

		@param String - (optional, string) The vibe pattern. Currently this only has one accepted value: DEFAULT.
		*/
		public void set_Vibe(String value) {
			this.setInput("Vibe", value);
		}


		/** 
		Set the value of the WeekDays input for this Choreo. 

		@param String - (required, string) Specifies the days of the week that the alarm is active. Required when specifying a "recurring" alarm. Multiple days can be specified in a comma-separated list (e.g., MONDAY,TUESDAY,WEDNESDAY).
		*/
		public void set_WeekDays(String value) {
			this.setInput("WeekDays", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateAlarm Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateAlarmResultSet extends ResultSet {
		public UpdateAlarmResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Fitbit.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
