package com.temboo.Library.NYTimes.CampaignFinance.PresidentialCampaigns;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PresidentialStateZipTotals

Retrieve the total amount of donations aggregated by a specified location (by state and/or zipcode).
*/
public class PresidentialStateZipTotals extends Choreography {

	/**
	Create a new instance of the PresidentialStateZipTotals Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PresidentialStateZipTotals(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/CampaignFinance/PresidentialCampaigns/PresidentialStateZipTotals"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PresidentialStateZipTotalsInputSet
	*/
	public PresidentialStateZipTotalsInputSet newInputSet() {
		return new PresidentialStateZipTotalsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PresidentialStateZipTotalsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PresidentialStateZipTotalsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PresidentialStateZipTotals
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PresidentialStateZipTotalsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CampaignCycle input for this Choreo. 

		@param Integer - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year. 
		*/
		public void set_CampaignCycle(Integer value) {
			this.setInput("CampaignCycle", value);
		}

		/** 
		Set the value of the CampaignCycle input for this Choreo as a String. 

		@param String - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year. 
		*/
		public void set_CampaignCycle(String value) {
			this.setInput("CampaignCycle", value);	
		}
		/** 
		Set the value of the Location input for this Choreo. 

		@param String - (required, string) Enter the location for which data will be retrieved. If ResourceType = states, use a two-letter state abbreviation (example: NY).  For zips, enter a five-digit zip code.
		*/
		public void set_Location(String value) {
			this.setInput("Location", value);
		}


		/** 
		Set the value of the ResourceType input for this Choreo. 

		@param String - (required, string) Specify the type of resource to use when retrieving donor data. Valid formats include: zips, or states.
		*/
		public void set_ResourceType(String value) {
			this.setInput("ResourceType", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Enter json or xml.  Default is json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PresidentialStateZipTotals Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PresidentialStateZipTotalsResultSet extends ResultSet {
		public PresidentialStateZipTotalsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API corresponds to the setting (json, or xml) entered in the ResponseFormat variable.  Default is set to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
