package com.temboo.Library.Xively.APIKeys;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateKey

Creates a new APIKey.
*/
public class CreateKey extends Choreography {

	/**
	Create a new instance of the CreateKey Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateKey(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/APIKeys/CreateKey"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateKeyInputSet
	*/
	public CreateKeyInputSet newInputSet() {
		return new CreateKeyInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateKeyResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateKeyResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateKey
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateKeyInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The master API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AccessMethods input for this Choreo. 

		@param String - (conditional, string) Comma-separated input containing one or more allowed HTTP methods that the key is allowed. Valid values: get, put, post, and/or delete. Ex.: "put,post". Required unless writing your own CustomKey.
		*/
		public void set_AccessMethods(String value) {
			this.setInput("AccessMethods", value);
		}


		/** 
		Set the value of the CustomKey input for this Choreo. 

		@param String - (optional, any) Optional Custom key to send to Xively. Type and format depends on CustomType. Please see documentation for more information on constructing your own body. If used, all other scalar inputs are ignored.
		*/
		public void set_CustomKey(String value) {
			this.setInput("CustomKey", value);
		}


		/** 
		Set the value of the CustomPermissions input for this Choreo. 

		@param String - (optional, any) Optional custom permissions for advanced configuration. Type and format depends on CustomType. If specified, ignores SourceIP, ResourcesData and AccessMethodsData.
		*/
		public void set_CustomPermissions(String value) {
			this.setInput("CustomPermissions", value);
		}


		/** 
		Set the value of the CustomType input for this Choreo. 

		@param String - (optional, string) The datatype that is being input if adding custom permission objects. Valid values are "json" (the default) and "xml".
		*/
		public void set_CustomType(String value) {
			this.setInput("CustomType", value);
		}


		/** 
		Set the value of the ExpirationDate input for this Choreo. 

		@param String - (optional, date) Expiration date for the key, after which it won't work. Must be in ISO 8601 format, default zone is UTC.  Ex: 2013-05-07T00:00:00Z.
		*/
		public void set_ExpirationDate(String value) {
			this.setInput("ExpirationDate", value);
		}


		/** 
		Set the value of the Label input for this Choreo. 

		@param String - (conditional, string) A label by which the key can be referenced. Required unless writing your own CustomKey.
		*/
		public void set_Label(String value) {
			this.setInput("Label", value);
		}


		/** 
		Set the value of the PrivateAccess input for this Choreo. 

		@param String - (optional, string) Flag that indicates whether this key can access private resources belonging to the user. To turn on, input "true", leave blank for "false".
		*/
		public void set_PrivateAccess(String value) {
			this.setInput("PrivateAccess", value);
		}


		/** 
		Set the value of the ResourceFeedID input for this Choreo. 

		@param Integer - (optional, integer) Specify a particular FeedID that the new APIKey should have access to. If not specified, the new APIKey permissions will apply to all feeds you are authorized to access.
		*/
		public void set_ResourceFeedID(Integer value) {
			this.setInput("ResourceFeedID", value);
		}

		/** 
		Set the value of the ResourceFeedID input for this Choreo as a String. 

		@param String - (optional, integer) Specify a particular FeedID that the new APIKey should have access to. If not specified, the new APIKey permissions will apply to all feeds you are authorized to access.
		*/
		public void set_ResourceFeedID(String value) {
			this.setInput("ResourceFeedID", value);	
		}
		/** 
		Set the value of the SourceIP input for this Choreo. 

		@param String - (optional, string) An IP address that, when specified, limits incoming requests to that specific IP address only.
		*/
		public void set_SourceIP(String value) {
			this.setInput("SourceIP", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateKey Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateKeyResultSet extends ResultSet {
		public CreateKeyResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "APIKeyLocation" output from this Choreo execution

		@return String - (string) The URL of the newly created APIKey.
		*/
		public String get_APIKeyLocation() {
			return this.getResultString("APIKeyLocation");
		}
		/** 
		Retrieve the value for the "NewAPIKey" output from this Choreo execution

		@return String - (string) The new APIKey obtained from the APIKeyLocation returned by this Choreo.
		*/
		public String get_NewAPIKey() {
			return this.getResultString("NewAPIKey");
		}
	}
	
}
