package com.temboo.Library.Google.Spreadsheets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveCellValue

Retrieves the value of given cell.
*/
public class RetrieveCellValue extends Choreography {

	/**
	Create a new instance of the RetrieveCellValue Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveCellValue(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Spreadsheets/RetrieveCellValue"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveCellValueInputSet
	*/
	public RetrieveCellValueInputSet newInputSet() {
		return new RetrieveCellValueInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveCellValueResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveCellValueResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveCellValue
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveCellValueInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the CellLocation input for this Choreo. 

		@param String - (required, string) The location of the cell that should be retrieved (e.g. A2).
		*/
		public void set_CellLocation(String value) {
			this.setInput("CellLocation", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Deprecated (retained for backward compatibility only).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the SpreadsheetKey input for this Choreo. 

		@param String - (conditional, string) The unique key of the spreadsheet associated with the cell you want to retrieve. Required unless SpreadsheetName and WorksheetName are supplied.
		*/
		public void set_SpreadsheetKey(String value) {
			this.setInput("SpreadsheetKey", value);
		}


		/** 
		Set the value of the SpreadsheetName input for this Choreo. 

		@param String - (optional, string) The name of the spreadsheet containing the cell to retrieve. This and WorksheetName can be used as an alternative to SpreadsheetKey and WorksheetId to lookup spreadsheet details by name.
		*/
		public void set_SpreadsheetName(String value) {
			this.setInput("SpreadsheetName", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WorksheetId input for this Choreo. 

		@param String - (conditional, string) The unique ID of the worksheet associated with the cell you want to retrieve. Required unless SpreadsheetName and WorksheetName are supplied.
		*/
		public void set_WorksheetId(String value) {
			this.setInput("WorksheetId", value);
		}


		/** 
		Set the value of the WorksheetName input for this Choreo. 

		@param String - (optional, string) The name of the worksheet containing the cell to retrieve. This and SpreadsheetName can be used as an alternative to SpreadsheetKey and WorksheetId to lookup the spreadsheet details by name.
		*/
		public void set_WorksheetName(String value) {
			this.setInput("WorksheetName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveCellValue Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveCellValueResultSet extends ResultSet {
		public RetrieveCellValueResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "CellValue" output from this Choreo execution

		@return String - (string) The value of the cell.
		*/
		public String get_CellValue() {
			return this.getResultString("CellValue");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
	}
	
}
