package com.temboo.Library.Google.Places;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RadarSearch

Search up to 200 places at once.   RadarSearch helps identify specific areas of interest within a geographic area.
*/
public class RadarSearch extends Choreography {

	/**
	Create a new instance of the RadarSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RadarSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Places/RadarSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RadarSearchInputSet
	*/
	public RadarSearchInputSet newInputSet() {
		return new RadarSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RadarSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RadarSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RadarSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RadarSearchInputSet extends InputSet {
		/** 
		Set the value of the Key input for this Choreo. 

		@param String - (required, string) The API Key provided by Google.
		*/
		public void set_Key(String value) {
			this.setInput("Key", value);
		}


		/** 
		Set the value of the Keyword input for this Choreo. 

		@param String - (conditional, string) Enter a keyword (term, address, type, customer review, etc.) to be matched against all results retrieved for this Place.  At least one of Keyword, Name or Types must be specified.
		*/
		public void set_Keyword(String value) {
			this.setInput("Keyword", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) The language code, indicating in which language the results should be returned, if possible. See Choreo notes for a list of supported languages and their codes.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param String - (required, string) Specify a latitude point around which Places results will be retrieved (e.g., 38.898717).
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);
		}


		/** 
		Set the value of the Longitude input for this Choreo. 

		@param String - (required, string) Specify a longitude point around which Places results will be retrieved (e.g., -77.035974).
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);
		}


		/** 
		Set the value of the MaxPrice input for this Choreo. 

		@param Integer - (optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.
		*/
		public void set_MaxPrice(Integer value) {
			this.setInput("MaxPrice", value);
		}

		/** 
		Set the value of the MaxPrice input for this Choreo as a String. 

		@param String - (optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.
		*/
		public void set_MaxPrice(String value) {
			this.setInput("MaxPrice", value);	
		}
		/** 
		Set the value of the MinPrice input for this Choreo. 

		@param Integer - (optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.
		*/
		public void set_MinPrice(Integer value) {
			this.setInput("MinPrice", value);
		}

		/** 
		Set the value of the MinPrice input for this Choreo as a String. 

		@param String - (optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.
		*/
		public void set_MinPrice(String value) {
			this.setInput("MinPrice", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (conditional, string) Enter a name to be matched when results are retrieved for this specified Place.  At least one of Keyword, Name or Types must be specified.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the OpenNow input for this Choreo. 

		@param Boolean - (optional, boolean) Returns only those Places that are open for business at the time the query is sent. Places that do not specify opening hours in the Google Places database will not be returned.
		*/
		public void set_OpenNow(Boolean value) {
			this.setInput("OpenNow", value);
		}

		/** 
		Set the value of the OpenNow input for this Choreo as a String. 

		@param String - (optional, boolean) Returns only those Places that are open for business at the time the query is sent. Places that do not specify opening hours in the Google Places database will not be returned.
		*/
		public void set_OpenNow(String value) {
			this.setInput("OpenNow", value);	
		}
		/** 
		Set the value of the PageToken input for this Choreo. 

		@param String - (optional, string) The "NextPageToken" returned in the choreo output from a previous run. Used to page through large result sets. When the PageToken is specified, all other inputs are ignored.
		*/
		public void set_PageToken(String value) {
			this.setInput("PageToken", value);
		}


		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (required, integer) Specify the radius in meters for which Places results will be returned. Maximum radius is limited to 50,000 meters.
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (required, integer) Specify the radius in meters for which Places results will be returned. Maximum radius is limited to 50,000 meters.
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sensor input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(Boolean value) {
			this.setInput("Sensor", value);
		}

		/** 
		Set the value of the Sensor input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).
		*/
		public void set_Sensor(String value) {
			this.setInput("Sensor", value);	
		}
		/** 
		Set the value of the Types input for this Choreo. 

		@param String - (conditional, string) Filter results by types, such as: bar, dentist.  Multiple types must be separated by the pipe ("|") symbol: bar|dentist|airport.   At least one of Keyword, Name or Types must be specified.
		*/
		public void set_Types(String value) {
			this.setInput("Types", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RadarSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RadarSearchResultSet extends ResultSet {
		public RadarSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
