package com.temboo.Library.Foursquare.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdatePhoto

Updates the user's profile photo.
*/
public class UpdatePhoto extends Choreography {

	/**
	Create a new instance of the UpdatePhoto Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdatePhoto(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Users/UpdatePhoto"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdatePhotoInputSet
	*/
	public UpdatePhotoInputSet newInputSet() {
		return new UpdatePhotoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdatePhotoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdatePhotoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdatePhoto
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdatePhotoInputSet extends InputSet {
		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (required, string) The content type of the image. Valid types are: image/jpeg, image/gif, or image/png.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API Oauth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the Photo input for this Choreo. 

		@param String - (conditional, string) The Base64-encoded contents of the image you want to upload. Total Image size (before encoding) must be under 100KB.
		*/
		public void set_Photo(String value) {
			this.setInput("Photo", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ImageAlias input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdatePhoto Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdatePhotoResultSet extends ResultSet {
		public UpdatePhotoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
