package com.temboo.Library.Foursquare.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ToDosFromUser

Returns todos from a user.
*/
public class ToDosFromUser extends Choreography {

	/**
	Create a new instance of the ToDosFromUser Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ToDosFromUser(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Users/ToDosFromUser"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ToDosFromUserInputSet
	*/
	public ToDosFromUserInputSet newInputSet() {
		return new ToDosFromUserInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ToDosFromUserResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ToDosFromUserResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ToDosFromUser
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ToDosFromUserInputSet extends InputSet {
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Enter: recent, nearby, or popular. NEARBY requires geolat and geolong to be provided.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) Identity of the user to get tips for. Defaults to "self" to get lists of the acting user.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ToDosFromUser Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ToDosFromUserResultSet extends ResultSet {
		public ToDosFromUserResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
