package com.temboo.Library.Foursquare.Settings;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ChangeSetting

Changes a setting for the given user.
*/
public class ChangeSetting extends Choreography {

	/**
	Create a new instance of the ChangeSetting Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ChangeSetting(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Settings/ChangeSetting"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ChangeSettingInputSet
	*/
	public ChangeSettingInputSet newInputSet() {
		return new ChangeSettingInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ChangeSettingResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ChangeSettingResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ChangeSetting
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ChangeSettingInputSet extends InputSet {
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (conditional, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SettingID input for this Choreo. 

		@param String - (required, string) Name of setting to change. Valid values are: sendMayorshipsToTwitter, sendBadgesToTwitter, sendMayorshipsToFacebook, sendBadgesToFacebook, receivePings, and receiveCommentPings.
		*/
		public void set_SettingID(String value) {
			this.setInput("SettingID", value);
		}


		/** 
		Set the value of the Value input for this Choreo. 

		@param Boolean - (required, boolean) The value of the setting you want to change. Set to 1 for true, and 0 for false.
		*/
		public void set_Value(Boolean value) {
			this.setInput("Value", value);
		}

		/** 
		Set the value of the Value input for this Choreo as a String. 

		@param String - (required, boolean) The value of the setting you want to change. Set to 1 for true, and 0 for false.
		*/
		public void set_Value(String value) {
			this.setInput("Value", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ChangeSetting Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ChangeSettingResultSet extends ResultSet {
		public ChangeSettingResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
