package com.temboo.Library.Foursquare.Photos;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddPhoto

Allows a user to add a new photo to a check-in, tip, or a venue.
*/
public class AddPhoto extends Choreography {

	/**
	Create a new instance of the AddPhoto Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddPhoto(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Photos/AddPhoto"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddPhotoInputSet
	*/
	public AddPhotoInputSet newInputSet() {
		return new AddPhotoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddPhotoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddPhotoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddPhoto
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddPhotoInputSet extends InputSet {
		/** 
		Set the value of the Altitude input for this Choreo. 

		@param Integer - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(Integer value) {
			this.setInput("Altitude", value);
		}

		/** 
		Set the value of the Altitude input for this Choreo as a String. 

		@param String - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(String value) {
			this.setInput("Altitude", value);	
		}
		/** 
		Set the value of the AltitudeAccuracy input for this Choreo. 

		@param Integer - (optional, integer) Vertical accuracy of the user's location, in meters.
		*/
		public void set_AltitudeAccuracy(Integer value) {
			this.setInput("AltitudeAccuracy", value);
		}

		/** 
		Set the value of the AltitudeAccuracy input for this Choreo as a String. 

		@param String - (optional, integer) Vertical accuracy of the user's location, in meters.
		*/
		public void set_AltitudeAccuracy(String value) {
			this.setInput("AltitudeAccuracy", value);	
		}
		/** 
		Set the value of the Broadcast input for this Choreo. 

		@param String - (optional, string) Whether to broadcast this photo. Set to "twitter" if you want to send to twitter, "facebook "if you want to send to facebook, or "twitter,facebook" if you want to send to both.
		*/
		public void set_Broadcast(String value) {
			this.setInput("Broadcast", value);
		}


		/** 
		Set the value of the CheckinID input for this Choreo. 

		@param String - (conditional, any) The ID of the checkin to attach a photo to. One of the id fields (CheckinID, TipID, or VenueID) must be specified.
		*/
		public void set_CheckinID(String value) {
			this.setInput("CheckinID", value);
		}


		/** 
		Set the value of the ImageFile input for this Choreo. 

		@param String - (conditional, string) The base64 encoded image contents. Required unless using the VaultFile alias (an advanced option used when running Choreos in the Temboo Designer).
		*/
		public void set_ImageFile(String value) {
			this.setInput("ImageFile", value);
		}


		/** 
		Set the value of the LLAccuracy input for this Choreo. 

		@param Integer - (optional, integer) Accuracy of the user's latitude and longitude, in meters.
		*/
		public void set_LLAccuracy(Integer value) {
			this.setInput("LLAccuracy", value);
		}

		/** 
		Set the value of the LLAccuracy input for this Choreo as a String. 

		@param String - (optional, integer) Accuracy of the user's latitude and longitude, in meters.
		*/
		public void set_LLAccuracy(String value) {
			this.setInput("LLAccuracy", value);	
		}
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) Laitude of the user's location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) Laitude of the user's location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) Longitude of the user's location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) Longitude of the user's location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the TipID input for this Choreo. 

		@param String - (conditional, string) The ID of the tip to attach a photo to. One of the id fields (CheckinID, TipID, or VenueID) must be specified.
		*/
		public void set_TipID(String value) {
			this.setInput("TipID", value);
		}


		/** 
		Set the value of the VenueID input for this Choreo. 

		@param String - (conditional, string) The ID of the venue to attach a photo to. One of the id fields (CheckinID, TipID, or VenueID) must be specified.
		*/
		public void set_VenueID(String value) {
			this.setInput("VenueID", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - A path to an image in the vault. Required unless specifying the ImageFile input variable.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddPhoto Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddPhotoResultSet extends ResultSet {
		public AddPhotoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
