package com.temboo.Library.CorpWatch.Search;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CompoundSearch

Returns a list of companies according to several search parameters such as industry, location, date range, company name, etc.
*/
public class CompoundSearch extends Choreography {

	/**
	Create a new instance of the CompoundSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CompoundSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CorpWatch/Search/CompoundSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CompoundSearchInputSet
	*/
	public CompoundSearchInputSet newInputSet() {
		return new CompoundSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CompoundSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CompoundSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CompoundSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CompoundSearchInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The APIKey from CorpWatch if you have one.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (conditional, string) Specific fragment of an address to be searched, such as "empire" or "Main Street."
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (optional, string) Two-letter country code (e.g. VI for Virgin Islands).
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the IndustryCode input for this Choreo. 

		@param Integer - (conditional, integer) Standard Industrial Classification (SIC) code.
		*/
		public void set_IndustryCode(Integer value) {
			this.setInput("IndustryCode", value);
		}

		/** 
		Set the value of the IndustryCode input for this Choreo as a String. 

		@param String - (conditional, integer) Standard Industrial Classification (SIC) code.
		*/
		public void set_IndustryCode(String value) {
			this.setInput("IndustryCode", value);	
		}
		/** 
		Set the value of the IndustrySector input for this Choreo. 

		@param Integer - (conditional, integer) Standard Industrial Classification (SIC) sector code.
		*/
		public void set_IndustrySector(Integer value) {
			this.setInput("IndustrySector", value);
		}

		/** 
		Set the value of the IndustrySector input for this Choreo as a String. 

		@param String - (conditional, integer) Standard Industrial Classification (SIC) sector code.
		*/
		public void set_IndustrySector(String value) {
			this.setInput("IndustrySector", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Match input for this Choreo. 

		@param Integer - (optional, integer) By default search terms match against complete words. Use 1 to return cases where the search string matches anywhere in the Name or Address field. Performance is significantly affected when enabled.
		*/
		public void set_Match(Integer value) {
			this.setInput("Match", value);
		}

		/** 
		Set the value of the Match input for this Choreo as a String. 

		@param String - (optional, integer) By default search terms match against complete words. Use 1 to return cases where the search string matches anywhere in the Name or Address field. Performance is significantly affected when enabled.
		*/
		public void set_Match(String value) {
			this.setInput("Match", value);	
		}
		/** 
		Set the value of the MaxYear input for this Choreo. 

		@param Integer - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MaxYear(Integer value) {
			this.setInput("MaxYear", value);
		}

		/** 
		Set the value of the MaxYear input for this Choreo as a String. 

		@param String - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MaxYear(String value) {
			this.setInput("MaxYear", value);	
		}
		/** 
		Set the value of the MinYear input for this Choreo. 

		@param Integer - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MinYear(Integer value) {
			this.setInput("MinYear", value);
		}

		/** 
		Set the value of the MinYear input for this Choreo as a String. 

		@param String - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MinYear(String value) {
			this.setInput("MinYear", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (conditional, string) Company name to search. Words in the search query must match to full words in the name. See documentation for more details.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the NumChildren input for this Choreo. 

		@param Integer - (optional, integer) Limit results to those with a specified number of listed subsidiaries, or "children." (Only immediate relationships are counted.
		*/
		public void set_NumChildren(Integer value) {
			this.setInput("NumChildren", value);
		}

		/** 
		Set the value of the NumChildren input for this Choreo as a String. 

		@param String - (optional, integer) Limit results to those with a specified number of listed subsidiaries, or "children." (Only immediate relationships are counted.
		*/
		public void set_NumChildren(String value) {
			this.setInput("NumChildren", value);	
		}
		/** 
		Set the value of the NumParents input for this Choreo. 

		@param Integer - (optional, integer) Limit results to those with a specified number of listed parent companies (only immediate relationships are counted).
		*/
		public void set_NumParents(Integer value) {
			this.setInput("NumParents", value);
		}

		/** 
		Set the value of the NumParents input for this Choreo as a String. 

		@param String - (optional, integer) Limit results to those with a specified number of listed parent companies (only immediate relationships are counted).
		*/
		public void set_NumParents(String value) {
			this.setInput("NumParents", value);	
		}
		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Specify json or xml for the type of response to be returned. Defaults to xml.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the SourceType input for this Choreo. 

		@param String - (optional, string) Indicate "filers" to restrict results to those of companies that appeared as a filer on SEC documents, or "relationships" for companies that only appear as subsidiaries on filings.
		*/
		public void set_SourceType(String value) {
			this.setInput("SourceType", value);
		}


		/** 
		Set the value of the SubdivisionCode input for this Choreo. 

		@param String - (optional, string) Two-letter abbreviation for the subdivision of the area to be searched (e.g. "OR" for Oregon when CountryCode is set to "US").
		*/
		public void set_SubdivisionCode(String value) {
			this.setInput("SubdivisionCode", value);
		}


		/** 
		Set the value of the TopParent input for this Choreo. 

		@param Integer - (optional, integer) Limit results by he CWID of the highest-level owning parent of a family of corprorations (or Top Parent). Most company records contain a field for top_parent_id.
		*/
		public void set_TopParent(Integer value) {
			this.setInput("TopParent", value);
		}

		/** 
		Set the value of the TopParent input for this Choreo as a String. 

		@param String - (optional, integer) Limit results by he CWID of the highest-level owning parent of a family of corprorations (or Top Parent). Most company records contain a field for top_parent_id.
		*/
		public void set_TopParent(String value) {
			this.setInput("TopParent", value);	
		}
		/** 
		Set the value of the Year input for this Choreo. 

		@param Integer - (optional, integer) If a year is specified, only records for that year will be returned and the data in the company objects returned will be set appropriately for the request year. Defaults to most recent.
		*/
		public void set_Year(Integer value) {
			this.setInput("Year", value);
		}

		/** 
		Set the value of the Year input for this Choreo as a String. 

		@param String - (optional, integer) If a year is specified, only records for that year will be returned and the data in the company objects returned will be set appropriately for the request year. Defaults to most recent.
		*/
		public void set_Year(String value) {
			this.setInput("Year", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CompoundSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CompoundSearchResultSet extends ResultSet {
		public CompoundSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from CorpWatch.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
