package com.temboo.Library.CorpWatch.Lists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListNames

Returns a list of names (companies or individuals) matching a given name query.
*/
public class ListNames extends Choreography {

	/**
	Create a new instance of the ListNames Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListNames(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CorpWatch/Lists/ListNames"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListNamesInputSet
	*/
	public ListNamesInputSet newInputSet() {
		return new ListNamesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListNamesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListNamesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListNames
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListNamesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The APIKey from CorpWatch if you have one.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) Set the index number of the first result to be returned. The index of the first result is 0.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to be returned. Defaults to 100. Maximum is 5000.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the MaxYear input for this Choreo. 

		@param Integer - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MaxYear(Integer value) {
			this.setInput("MaxYear", value);
		}

		/** 
		Set the value of the MaxYear input for this Choreo as a String. 

		@param String - (optional, integer) Indicate desired year of the most recent appearance in SEC filing data (e.g. indicating 2007 will search for companies that ceased filing in 2007).
		*/
		public void set_MaxYear(String value) {
			this.setInput("MaxYear", value);	
		}
		/** 
		Set the value of the MinYear input for this Choreo. 

		@param Integer - (optional, integer) Indicate desired year of the earliest appearance in SEC filing data (e.g. indicating 2004 will search for companies that started filing in 2004).
		*/
		public void set_MinYear(Integer value) {
			this.setInput("MinYear", value);
		}

		/** 
		Set the value of the MinYear input for this Choreo as a String. 

		@param String - (optional, integer) Indicate desired year of the earliest appearance in SEC filing data (e.g. indicating 2004 will search for companies that started filing in 2004).
		*/
		public void set_MinYear(String value) {
			this.setInput("MinYear", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) Name to be searched.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Specify json or xml for the type of response to be returned. Defaults to xml.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


		/** 
		Set the value of the Source input for this Choreo. 

		@param String - (optional, string) Indicates how the name was derived. See documentation for more information on this parameter.
		*/
		public void set_Source(String value) {
			this.setInput("Source", value);
		}


		/** 
		Set the value of the Year input for this Choreo. 

		@param Integer - (optional, integer) If a year is specified, only records for that year will be returned and the data in the company objects returned will be set appropriately for the request year. Defaults to most recent.
		*/
		public void set_Year(Integer value) {
			this.setInput("Year", value);
		}

		/** 
		Set the value of the Year input for this Choreo as a String. 

		@param String - (optional, integer) If a year is specified, only records for that year will be returned and the data in the company objects returned will be set appropriately for the request year. Defaults to most recent.
		*/
		public void set_Year(String value) {
			this.setInput("Year", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListNames Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListNamesResultSet extends ResultSet {
		public ListNamesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from CorpWatch.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
