package com.temboo.Library.Xively.ReadWriteData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
WriteDatastreamMetadata

Allows you to easily update the metadata of your datastream.
*/
public class WriteDatastreamMetadata extends Choreography {

	/**
	Create a new instance of the WriteDatastreamMetadata Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public WriteDatastreamMetadata(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/ReadWriteData/WriteDatastreamMetadata"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return WriteDatastreamMetadataInputSet
	*/
	public WriteDatastreamMetadataInputSet newInputSet() {
		return new WriteDatastreamMetadataInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public WriteDatastreamMetadataResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new WriteDatastreamMetadataResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the WriteDatastreamMetadata
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class WriteDatastreamMetadataInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CurrentValue input for this Choreo. 

		@param String - (optional, string) The current value of the datastream. Leave empty to keep existing  CurrentValue. Type "BLANK" to clear existing value.
		*/
		public void set_CurrentValue(String value) {
			this.setInput("CurrentValue", value);
		}


		/** 
		Set the value of the CustomDatastreamData input for this Choreo. 

		@param String - (optional, json) Custom datastream formatted as a JSON array. See documentation for how to construct your own datastream feed. If custom DatastreamData is used, all other optional inputs are ignored.
		*/
		public void set_CustomDatastreamData(String value) {
			this.setInput("CustomDatastreamData", value);
		}


		/** 
		Set the value of the DatastreamID input for this Choreo. 

		@param String - (required, string) The ID of the Datastream you would like to add metadata to. Required unless you are using CustomDatastreamData.
		*/
		public void set_DatastreamID(String value) {
			this.setInput("DatastreamID", value);
		}


		/** 
		Set the value of the FeedID input for this Choreo. 

		@param Integer - (required, integer) The ID for the feed that you would like to update.
		*/
		public void set_FeedID(Integer value) {
			this.setInput("FeedID", value);
		}

		/** 
		Set the value of the FeedID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the feed that you would like to update.
		*/
		public void set_FeedID(String value) {
			this.setInput("FeedID", value);	
		}
		/** 
		Set the value of the MaxValue input for this Choreo. 

		@param String - (optional, string) The maximum value since the last reset. Leave empty to keep existing MaxValue. Type "BLANK" to clear existing value.
		*/
		public void set_MaxValue(String value) {
			this.setInput("MaxValue", value);
		}


		/** 
		Set the value of the MinValue input for this Choreo. 

		@param String - (optional, string) The minimum value since the last reset. Leave empty to keep existing MinValue. Type "BLANK" to clear existing value.
		*/
		public void set_MinValue(String value) {
			this.setInput("MinValue", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) Comma-separated list of searchable tags (the characters ', ", and commas are not allowed). Tags input overwrites previous tags, enter "BLANK" to clear all tags. Ex: "power,energy".
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


		/** 
		Set the value of the UnitSymbol input for this Choreo. 

		@param String - (optional, string) The symbol of the Unit. Leave empty to keep existing UnitSymbol. Type "BLANK" to clear existing value. Ex: "C".
		*/
		public void set_UnitSymbol(String value) {
			this.setInput("UnitSymbol", value);
		}


		/** 
		Set the value of the UnitType input for this Choreo. 

		@param String - (optional, string) The type of Unit. Leave empty to keep existing UnitType. Type "BLANK" to clear existing value. Ex: "basicSI".
		*/
		public void set_UnitType(String value) {
			this.setInput("UnitType", value);
		}


		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) The units of the datastream. Leave empty to keep existing Units. Type "BLANK" to clear existing Units. Ex: "Celsius".
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the WriteDatastreamMetadata Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class WriteDatastreamMetadataResultSet extends ResultSet {
		public WriteDatastreamMetadataResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Xively. For a successful datastream update, the code should be 200.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
	}
	
}
