package com.temboo.Library.Bitly.LinkMetrics;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetReferringDomains

Returns metrics about the domains referring click traffic to a single Bitly link.
*/
public class GetReferringDomains extends Choreography {

	/**
	Create a new instance of the GetReferringDomains Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetReferringDomains(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Bitly/LinkMetrics/GetReferringDomains"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetReferringDomainsInputSet
	*/
	public GetReferringDomainsInputSet newInputSet() {
		return new GetReferringDomainsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetReferringDomainsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetReferringDomainsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetReferringDomains
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetReferringDomainsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The OAuth access token provided by Bitly.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The result limit. Defaults to 100. Range is 1 to 1000.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The result limit. Defaults to 100. Range is 1 to 1000.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Link input for this Choreo. 

		@param String - (required, string) A Bitly link.
		*/
		public void set_Link(String value) {
			this.setInput("Link", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that you want the response to be in. Accepted values are "json" or "xml". Defaults to "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Rollup input for this Choreo. 

		@param Boolean - (optional, boolean) Accepted values are true or false. When set to true, this returns data for multiple units rolled up to a single result instead of a separate value for each period of time.
		*/
		public void set_Rollup(Boolean value) {
			this.setInput("Rollup", value);
		}

		/** 
		Set the value of the Rollup input for this Choreo as a String. 

		@param String - (optional, boolean) Accepted values are true or false. When set to true, this returns data for multiple units rolled up to a single result instead of a separate value for each period of time.
		*/
		public void set_Rollup(String value) {
			this.setInput("Rollup", value);	
		}
		/** 
		Set the value of the Timestamp input for this Choreo. 

		@param String - (optional, date) An epoch timestamp, indicating the most recent time for which to pull metrics.
		*/
		public void set_Timestamp(String value) {
			this.setInput("Timestamp", value);
		}


		/** 
		Set the value of the Timezone input for this Choreo. 

		@param String - (optional, string) An integer hour offset from UTC (-12..12), or a timezone string. Defaults to "America/New_York".
		*/
		public void set_Timezone(String value) {
			this.setInput("Timezone", value);
		}


		/** 
		Set the value of the UnitName input for this Choreo. 

		@param String - (optional, string) The unit of time that corresponds to query you want to run. Accepted values are: minute, hour, day, week, month, and day. Defaults to "day".
		*/
		public void set_UnitName(String value) {
			this.setInput("UnitName", value);
		}


		/** 
		Set the value of the UnitValue input for this Choreo. 

		@param Integer - (optional, integer) An integer representing the amount of time to query for. Corresponds to the UnitName input. Defaults to -1 indicating to return all units of time.
		*/
		public void set_UnitValue(Integer value) {
			this.setInput("UnitValue", value);
		}

		/** 
		Set the value of the UnitValue input for this Choreo as a String. 

		@param String - (optional, integer) An integer representing the amount of time to query for. Corresponds to the UnitName input. Defaults to -1 indicating to return all units of time.
		*/
		public void set_UnitValue(String value) {
			this.setInput("UnitValue", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetReferringDomains Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetReferringDomainsResultSet extends ResultSet {
		public GetReferringDomainsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Bitly.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
